Rem
Rem $Header: rdfmatch.sql 04-may-2005.19:32:25 geadon Exp $
Rem
Rem rdfmatch.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rdfmatch.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    geadon      05/04/05 - rulebase interface change 
Rem    geadon      05/02/05 - use SDO_RDF_INFERENCE synonym 
Rem    echong      04/27/05 - add test for user-rule filter 
Rem    geadon      04/26/05 - interface name changes 
Rem    geadon      04/21/05 - simply URIs for demo 
Rem    echong      04/21/05 - add demo for user-defined rules 
Rem    geadon      04/18/05 - Update for RDF_APIS interface change 
Rem    geadon      03/07/05 - geadon_rdf_query
Rem    geadon      03/07/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

--
-- Example SDO_RDF_MATCH queries to be run after demo data is loaded
--
connect scott/tiger;

-- 1) count triples in the NATURE2 model
select COUNT(*)
  from TABLE(SDO_RDF_MATCH('(?s ?p ?o)',
             SDO_RDF_Models('NATURE2'), null, null, null));

-- 2) select triples from NATURE model
select s, p, o
  from TABLE(SDO_RDF_MATCH('(?s ?p ?o)',
             SDO_RDF_Models('Nature'), null, null, null));

-- 3) select all columns from SDO_RDF_MATCH 
select *
  from TABLE(SDO_RDF_MATCH('(?s ?p ?o)',
             SDO_RDF_Models('Nature'), null, null, null))
  where rownum < 2;

-- 4) Job information from JOBS model
select title, postedOn, country
  from TABLE(
         SDO_RDF_MATCH('(?item rss:title   ?title)' ||
                       '(?item :postedOn   ?postedOn)' ||
                       '(?item :advertises ?job)' ||
                       '(?job  rdf:type    :Job)' ||
                       '(?job  :country    ?country)',
           SDO_RDF_Models('JOBS'),
           null,
           SDO_RDF_Aliases(
             SDO_RDF_Alias('',    'http://www.nature.com/ns/2004/03/jobs#'),
             SDO_RDF_Alias('rss', 'http://purl.org/rss/1.0/')
           ),
           null
         )
       );

-- 5) RDFS inferencing in the FAMILY model

exec SDO_RDF_INFERENCE.drop_rules_index ('rdfs_rix_family');
begin
  SDO_RDF_INFERENCE.create_rules_index('rdfs_rix_family',
                              SDO_RDF_Models('family'),
                              SDO_RDF_Rulebases('RDFS'));
end;
/

-- 5a) select Males from the family model, without inferencing
select m
  from TABLE(SDO_RDF_MATCH(
  	'(?m rdf:type :Male)',
         SDO_RDF_Models('family'),
        null,
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        null));

-- 5b) select all Males from the family model, with RDFS inferencing
select m
  from TABLE(SDO_RDF_MATCH(
	'(?m rdf:type :Male)',
        SDO_RDF_Models('family'),
        SDO_RDF_Rulebases('RDFS'), 
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        null));


-- 6) general inferencing in the FAMILY model

exec SDO_RDF_INFERENCE.create_rulebase('family_rb');

insert into mdsys.rdfr_family_rb values(
  'grandparent_rule',
  '(?x :parentOf ?y) (?y :parentOf ?z)',
  NULL,
  '(?x :grandParentOf ?z)', 
  SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')));


exec SDO_RDF_INFERENCE.drop_rules_index ('family_rb_rix_family');
begin
  SDO_RDF_INFERENCE.create_rules_index ('family_rb_rix_family',
	SDO_RDF_Models('family'),
        SDO_RDF_Rulebases('RDFS','family_rb'));
end;
/

-- 6a) select grandfathers from the family model, without inferencing
select x, y
  from TABLE(SDO_RDF_MATCH(
	'(?x :grandParentOf ?y) (?x rdf:type :Male)',
        SDO_RDF_Models('family'),
        null, 
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        null));

-- 6b) select grandfathers from the family model, with RDFS inferencing
--     in addition to inferencing via the "family_rb" rulebase.
select x, y
  from TABLE(SDO_RDF_MATCH(
	'(?x :grandParentOf ?y) (?x rdf:type :Male)',
        SDO_RDF_Models('family'),
        SDO_RDF_Rulebases('RDFS','family_rb'), 
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        null));

-- 6c) select grandfathers of tall (>= 6) grandchildren from the family model, 
--     with RDFS inferencing
--     in addition to inferencing via the "family_rb" rulebase.

update mdsys.rdfr_family_rb set
  antecedents = '(?x :parentOf ?y) (?y :parentOf ?z) (?z :height ?h)',
  filter = 'h >= 6',
  aliases = SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/'))
where rule_name = 'GRANDPARENT_RULE';

select index_name, status from mdsys.rdf_ruleindex_info;

begin
  SDO_RDF_INFERENCE.create_rules_index ('family_rb_rix_family',
	SDO_RDF_Models('family'),
      	SDO_RDF_RuleBases('RDFS','family_rb'));
end;
/
select index_name, status from mdsys.rdf_ruleindex_info;

select x, y
  from TABLE(SDO_RDF_MATCH(
	'(?x :grandParentOf ?y) (?x rdf:type :Male)',
        SDO_RDF_Models('family'),
        SDO_RDF_RuleBases('RDFS','family_rb'), 
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        null));

-- 7) Multiple representations of the same scalar value

-- 7a) find Jack's height
select h, h$rdfltyp
  from TABLE(SDO_RDF_MATCH(
        '(:Jack :height ?h)',
        SDO_RDF_Models('family'), null,
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        null));

-- 7b) find Cindy's height. Note that it's lexically different from Jack's
--     and it's a different type (Cindy's height is typed as decimal
--     while Jack's was typed as integer). However, Cindy and Jack
--     have equivalent heights in value-space.
select h, h$rdfltyp
  from TABLE(SDO_RDF_MATCH(
        '(:Cindy :height ?h)',
        SDO_RDF_Models('family'), null,
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        null));

-- 7c) query for two different people who have the same height.
--     Since we match literals by value (as opposed to matching
--     by lexical representation) Jack and Cindy will match.
--     Notice that we use SDO_RDF_MATCH's "filter" paramter to ensure
--     that we don't match people with themselves, and that 
--     we match each pair of people only once. (Note that a 'p0 != p1'
--     filter would yield <Jack, Cindy> in addition to <Cindy, Jack>).
select p0, p1
  from TABLE(SDO_RDF_MATCH(
        '(?p0 :height ?h) (?p1 :height ?h)',
        SDO_RDF_Models('family'), null,
	SDO_RDF_Aliases(SDO_RDF_Alias('','http://www.example.org/family/')),
        'p0 < p1'));
